import math

# -------------------------
# Configuration
# -------------------------
SEED_VECTORS = 8
FOLD_DOUBLINGS = 21  # 2^21 * 8 = 16,777,216 vectors
SCALE = 10**10
FIBS = [1,1,2,3,5,8,13,21,34,55,89,144,233,377,610]  # Fibonacci delta for uniqueness

# Seed vectors: list of tuples (vector_hex, omega_hex)
SEED_PARAMS = [
    ("0x00000000000000000000000000000000", "0x12a05f20012a05f2"),
    ("0x09502f9009502f9009502f9009502f90", "0x1bf08eb01bf08eb0"),
    ("0x12a05f2012a05f2012a05f2012a05f20", "0x2540be402540be40"),
    ("0x1bf08eb01bf08eb01bf08eb01bf08eb0", "0x2e90edd02e90edd0"),
    ("0x2540be402540be402540be402540be40", "0x37e11d6037e11d60"),
    ("0x2e90edd02e90edd02e90edd02e90edd0", "0x41314cf041314cf0"),
    ("0x37e11d6037e11d6037e11d6037e11d60", "0x4a817c804a817c80"),
    ("0x41314cf041314cf041314cf041314cf0", "0x53d1ac1053d1ac10"),
]

CTv_PUBKEY = "<YOUR_PUBLIC_KEY>"  # Replace with actual hex pubkey

# -------------------------
# Script generation
# -------------------------
script = [f"{CTv_PUBKEY} OP_CHECKSIGVERIFY"]

vector_count = SEED_VECTORS
fib_index = 0

# Add seed vectors first
for vector_hex, omega_hex in SEED_PARAMS:
    omega_int = int(omega_hex, 16)
    fib_delta = FIBS[fib_index % len(FIBS)]
    fib_index += 1
    omega_min = omega_int + fib_delta
    omega_max = omega_int + fib_delta

    script.append(f"{vector_hex} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
    script.append(f"{vector_count} {vector_count} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
    script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
    script.append("")

# Folding doublings
for fold in range(FOLD_DOUBLINGS):
    vector_count *= 2
    fib_delta = FIBS[fib_index % len(FIBS)]
    fib_index += 1

    # Pick a seed param cyclically for omega
    param = SEED_PARAMS[fold % len(SEED_PARAMS)]
    omega_int = int(param[1], 16)
    omega_min = omega_int + fib_delta
    omega_max = omega_int + fib_delta

    script.append(f"OP_VEC_DUP {vector_count//2} OP_HDGL_VEC_ADD OP_EQUALVERIFY")
    script.append(f"{vector_count//2} {vector_count//2} OP_HDGL_PARAM_ADD OP_EQUALVERIFY")
    script.append(f"{omega_int} {omega_min} {omega_max} OP_WITHINVERIFY")
    script.append("")

script.append("OP_CHECKTEMPLATEVERIFY")

# -------------------------
# Output
# -------------------------
with open("hdgl_covenant_16M.txt", "w") as f:
    f.write("\n".join(script))

print("=== HDGL Covenant Generated: 16,777,216 unique vectors ===")
